---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Dissonance (dynamic)

> Persistent phase conflict/tension; may be informative (edge detection) or destructive (instability).

---

## Definition

- Phase conflict pattern
- Productive or destructive
- Tension dynamics
- Edge detection role

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Phase clash | State conflict | `Monitor`, `Clash` |
| Edge detect | Pattern break | `Check`, `Edge` |
| Tension | Load stress | `Test`, `Stress` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Phase clash | Not fitting | "Doesn't work" |
| Edge detect | Finding limits | "Sees bounds" |
| Tension | Feeling strain | "Under stress" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| State conflict | Not fitting | How clash works |
| Pattern break | Finding limits | How edges form |
| Load stress | Feeling strain | How tension builds |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Mode clash | Energy strain |
| Networks | Service clash | Link stress |
| Cognition | Pattern clash | Thought strain |
| Systems | State clash | Flow stress |

---

## Scale Effects

How Dissonance manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum clash | Wave break |
| λV | Gate stress | State clash |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase clash | Pattern break |
| ∇S | Edge clarity | Clear bounds |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave clash | Light break |
| λV | Field stress | Space strain |

Note: At extreme scales, dissonance faces fundamental limits (e.g., quantum uncertainty at ε, causal tension at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: conflict above noise
- π: phase clash clear
- ψA: tension bounded
- λV: gates stressed

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Edge detect | Wave break |
| Human | λV | Gate stress | Flow strain |
| Cosmic | ψA | Phase clash | Field tension |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Over-clash | Pattern break | Lost form |
| Human | Bad stress | Growth block | Too much |
| Cosmic | Field break | Structure clash | Lost order |

---

## Diagnostic Checklist

Technical tests:
- [ ] Clash contained
- [ ] Edges useful
- [ ] Stress bounded
- [ ] Flow managed

Humane tests:
- [ ] Tension productive
- [ ] Limits clear
- [ ] Strain bearable
- [ ] Growth possible

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical conflict nor experiential tension alone captures its full meaning.

---

## See Also

- [[Resonance (dynamic)]]
- [[Interference (dynamic)]]
- [[Harmony (dynamic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented